﻿using CodeWalker.GameFiles;
using CodeWalker.World;
using System;
using System.Collections.Generic;
using System.Data;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace RPFTools
{
    internal class Program
    {
        static void Main(string[] args)
        {
            //GTA5Keys.LoadFromPath("X:\\Grand Theft Auto V\\Keys");
            //byte[] exedat = File.ReadAllBytes("X:\\gta5\\titleupdate\\dev_ng\\GTA5.exe");
            //GTA5Keys.GenerateV2(exedat, (string status) => Console.Error.WriteLine(status));
            GTA5Keys.LoadFromPath(".\\Keys", "s4lzr4ueJjqN8XAyFEKzk4vT8h+k0E3/iC4EZg/5nf0=");

            string rpfPath = "X:\\gta5\\titleupdate\\dev_ng";

            RenameSwitchToX64(rpfPath);
            BulkDefragment(rpfPath);
            DecryptEverything(rpfPath);
            RemoveHDResources(rpfPath);
            RenameX64ToSwitch(rpfPath);
        }

        static void RenameSwitchToX64(string platformPackFolder)
        {
            foreach (var file in Directory.EnumerateFiles(platformPackFolder))
            {
                if (!file.Contains("\\switch") || !file.EndsWith(".rpf")) continue;

                string newName = file.Replace("switch", "x64");
                Console.WriteLine(file, newName);
                File.Move(file, newName);
            }
        }

        static void RenameX64ToSwitch(string platformPackFolder)
        {
            foreach (var file in Directory.EnumerateFiles(platformPackFolder))
            {
                if (!file.Contains("\\x64") || !file.EndsWith(".rpf")) continue;

                string newName = file.Replace("x64", "switch");
                Console.WriteLine(file, newName);
                File.Move(file, newName);
            }
        }

        static void BulkDefragment(string platformPackFolder)
        {
            foreach (var file in Directory.EnumerateFiles(platformPackFolder))
            {
                //Console.WriteLine(file);
                if (!file.EndsWith(".rpf")) continue;

                Console.WriteLine($"Parsing RPF: {file}");

                var rpf = new RpfFile(file, "");
                rpf.ScanStructure(
                    (string status) => Console.Error.WriteLine("[status] " + status), 
                    (string error) => {
                        Console.Error.WriteLine("[error]" + error);
                    });

                RpfFile.SetEncryptionType(rpf, RpfEncryption.OPEN);

                /*foreach (var child in rpf.Children)
                {
                    Console.WriteLine("Defragmenting: " + child.Name);
                    RpfFile.SetEncryptionType(child, RpfEncryption.OPEN);
                    RpfFile.Defragment(child, (string status, float progress) =>
                    {
                        Console.Error.WriteLine("[status] " + status + " " + ((int)(100 % progress)) + "%");
                    });
                }*/
                /*RpfFile.Defragment(rpf, (string status, float progress) =>
                {
                    Console.Error.WriteLine("[status] " + status + " " + ((int)(100 % progress)) + "%");
                });*/
            }
        }

        static void DecryptEverything(string platformPackFolder)
        {
            RecurseRpfAction(platformPackFolder, DecryptRpf);
        }

        static void RemoveHDResources(string platformPackFolder)
        {
            RecurseRpfAction(platformPackFolder, RemoveHDFromRpf);
        }

        static void RecurseRpfAction(string platformPackFolder, Action<RpfFile> action)
        {
            foreach (var file in Directory.EnumerateFiles(platformPackFolder))
            {
                //Console.WriteLine(file);
                if (!file.EndsWith(".rpf")) continue;

                var rpf = new RpfFile(file, "");

                bool hasError = false;
                rpf.ScanStructure(
                    (string status) => { },
                    (string error) => {
                        Console.Error.WriteLine(error);
                        hasError = true;
                    });
                action(rpf);
                foreach (var childRpf in rpf.Children)
                {
                    action(childRpf);
                }
            }
        }

        static void RemoveHDFromRpf(RpfFile rpf)
        {
            RpfFile.SetEncryptionType(rpf, RpfEncryption.OPEN);
            foreach (var entry in new List<RpfEntry>(rpf.AllEntries))
            {
                if (entry is RpfBinaryFileEntry || entry is RpfResourceFileEntry)
                {
                    if (!entry.Name.EndsWith("+hi.ytd") && !entry.Name.EndsWith("+hidr.ytd") && !entry.Name.EndsWith("+hidd.ytd") && !entry.Name.EndsWith("+hifr.ytd")) 
                        continue;

                    Console.WriteLine($"Delete HI resource {entry.Name}");
                    RpfFile.DeleteEntry(entry);
                }
            }
        }

        static void DecryptRpf(RpfFile rpf)
        {
            RpfFile.SetEncryptionType(rpf, RpfEncryption.OPEN);
            foreach (var entry in new List<RpfEntry>(rpf.AllEntries))
            {
                if (entry is RpfBinaryFileEntry)
                {
                    if (entry.Name.EndsWith(".rpf")) continue;

                    var binEntry = (RpfBinaryFileEntry)entry;
                    if (!binEntry.IsEncrypted) continue;

                    byte[] data = rpf.ExtractFile(binEntry);
                    if (data == null)
                    {
                        Console.Error.WriteLine(rpf.Path);
                        Console.Error.WriteLine("Failed to extract " + binEntry.Name);
                        Console.Error.WriteLine(rpf.LastException);
                        continue;
                    }

                    Console.WriteLine($"Decrypting {binEntry.Name} ({data.Length})");
                    RpfFile.CreateFile(binEntry.Parent, binEntry.Name, data);
                } else if (entry is RpfResourceFileEntry)
                {
                    var resEntry = (RpfResourceFileEntry)entry;
                    if (!resEntry.IsEncrypted) continue;
                    if (!resEntry.Name.EndsWith(".ysc")) continue;

                    byte[] data = rpf.ExtractFile(resEntry);
                    if (data == null)
                    {
                        Console.Error.WriteLine(rpf.Path);
                        Console.Error.WriteLine("Failed to extract " + resEntry.Name);
                        Console.Error.WriteLine(rpf.LastException);
                        continue;
                    }

                    if (data[0] != 0xa8 || data[1] != 0xb3 || data[2] != 0xc2 || data[3] != 0x8f)
                    {
                        resEntry.IsEncrypted = false;
                        data = rpf.ExtractFile(resEntry);
                        Console.Error.WriteLine($"File already decrypted: {resEntry.Name}");
                    }

                    if (data[0] != 0xa8 || data[1] != 0xb3 || data[2] != 0xc2 || data[3] != 0x8f)
                    {
                        throw new Exception("Invalid Script File header!");
                    }

                    data = RpfFile.CompressBytes(data);
                    data = ResourceBuilder.AddResourceHeader(resEntry, data);

                    if (data[0] != 'R' || data[1] != 'S' || data[2] != 'C' || data[3] != '7')
                    {
                        throw new Exception("Invalid Resource File header!");
                    }

                    Console.WriteLine($"Decrypting {resEntry.Name} ({data.Length})");
                    RpfFile.CreateFile(resEntry.Parent, resEntry.Name, data);
                }
            }
        }
    }

}
